
<?php $__env->startSection('panel'); ?>
<div class="card">
    <div class="card-body">
        <div class="content-header">
            <h3>
                <?php echo app('translator')->get('Invoice #'); ?>
                <small><?php echo e($courierInfo->invoice_id); ?></small>
            </h3>
        </div>

        <div class="invoice">
            <div class="row mt-3">
                <div class="col-lg-6">
                    <?php echo $code ?>
                </div>
                <div class="col-lg-6">
                    <h5 class="float-sm-right"><?php echo app('translator')->get('Date'); ?>: <?php echo e(showDateTime($courierInfo->created_at, 'd M Y')); ?></h5>
                </div>
            </div>
            <hr>
            <div class="row invoice-info">
                <div class="col-md-4">
                    <?php echo app('translator')->get('From'); ?>
                    <address class="font-weight-light">
                        <strong><?php echo e(__($courierInfo->sender_name)); ?></strong><br>
                        <?php echo e(__($courierInfo->sender_address)); ?><br>
                        <?php echo app('translator')->get('Phone'); ?>: <?php echo e(__($courierInfo->sender_phone)); ?><br>
                        <?php echo app('translator')->get('Email'); ?>: <?php echo e(__($courierInfo->sender_email)); ?>

                    </address>
                </div>
                <div class="col-md-4">
                  To
                    <address class="font-weight-light">
                        <strong><?php echo e(__($courierInfo->receiver_name)); ?></strong><br>
                        <?php echo e(__($courierInfo->receiver_address)); ?><br>
                        <?php echo app('translator')->get('Phone'); ?>: <?php echo e(__($courierInfo->receiver_phone)); ?><br>
                        <?php echo app('translator')->get('Email'); ?>: <?php echo e(__($courierInfo->receiver_email)); ?>

                    </address>
                </div>

                <div class="col-md-4 font-weight-light">
                    <b><?php echo app('translator')->get('Order Id'); ?> #<?php echo e(__($courierInfo->code)); ?></b><br>
                    <br>
                    <b><?php echo app('translator')->get('Payment Status'); ?>:</b> <?php if($courierPayment->status == 1): ?> 
                            <span class="badge badge--success"><?php echo app('translator')->get('Paid'); ?></span>
                        <?php else: ?>
                           <span class="badge badge--danger"><?php echo app('translator')->get('Unpaid'); ?></span>
                        <?php endif; ?>
                       <br>
                    <b><?php echo app('translator')->get('Sender At Branch'); ?>:</b> <?php echo e(__($courierInfo->senderBranch->name)); ?><br>
                    <b><?php echo app('translator')->get('Received At Branch'); ?>:</b> <?php echo e(__($courierInfo->receiverBranch->name)); ?>

                </div>
            </div>

            <div class="row">
                <div class="col-12 table-responsive--md">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo app('translator')->get('Courier Type'); ?></th>
                                <th><?php echo app('translator')->get('Sending Date'); ?></th>
                                <th><?php echo app('translator')->get('Qty'); ?></th>
                                <th><?php echo app('translator')->get('Subtotal'); ?></th>
                            </tr>
                        </thead>
                    <tbody>
                      <?php $__currentLoopData = $courierProductInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courierProductInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td data-label="#"><?php echo e($loop->iteration); ?></td>
                                <td data-label="Courier Type"><?php echo e(__($courierProductInfo->type->name)); ?></td>
                                <td data-label="Sending Date"><?php echo e(showDateTime($courierProductInfo->created_at, 'd M Y')); ?></td>
                                <td data-label="Qty"><?php echo e($courierProductInfo->qty); ?></td>
                                <td data-label="Subtotal"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($courierProductInfo->fee)); ?></td>
                            </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

            <div class="row mt-30 mb-none-30">
                <div class="col-lg-12 mb-30">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th style="width:50%"><?php echo app('translator')->get('Subtotal'); ?>:</th>
                                    <td><?php echo e($general->cur_sym); ?><?php echo e(getAmount($courierPayment->amount)); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo app('translator')->get('Total'); ?>:</th>
                                    <td><?php echo e($general->cur_sym); ?><?php echo e(getAmount($courierPayment->amount)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <hr>

            <div class="row no-print">
                <div class="col-sm-12">
                    <div class="float-sm-right">
                        <button class="btn btn-primary m-1 printInvoice"><i class="fa fa-download"></i><?php echo app('translator')->get('Print'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script>
  $('.printInvoice').click(function () { 
    window.print();
    return false;
  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/admin/courier/invoice.blade.php ENDPATH**/ ?>